package gov.va.genisis2.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;

/**
 * The Class WorkflowStatus.
 * 
 * Description: In this WorkflowStatus Class implements the interface
 * Serializable and defines the entity and data mapping for the
 * dbo.User_Approver Table in the database.
 */
@Entity
@Table(name = "WorkflowStatus", schema = "dbo")
public class WorkflowStatus implements Serializable {

	/**
	 * serialVersionUID field for serializable class
	 */
	private static final long serialVersionUID = 8856871498976013089L;

	/** The id. */
	@Id
	@Column(name = "Id", unique = true, nullable = false)
	private int id;

	/** The description. */
	@Column(name = "Description", length = 50)
	private String description;

	/** The comment histories. */
	@OneToMany(fetch = FetchType.LAZY, mappedBy = "workflowStatus")
	private Set<CommentHistory> commentHistories = new HashSet<>(0);

	@Transient
	private int status;

	@Transient
	private Long count;

	public WorkflowStatus() {
	}

	/**
	 * 
	 * @param status
	 *            the work flow statusId
	 * @param description
	 *            the work flow status description
	 * @param count
	 *            request count per work flow status
	 */
	public WorkflowStatus(int status, String description, Long count) {
		super();
		this.description = description;
		this.status = status;
		this.count = count;
	}

	/**
	 * @return the status
	 */
	public int getStatus() {
		return status;
	}

	/**
	 * @param status
	 *            the status to set
	 */
	public void setStatus(int status) {
		this.status = status;
	}

	/**
	 * @return the count
	 */
	public Long getCount() {
		return count;
	}

	/**
	 * @param count
	 *            the count to set
	 */
	public void setCount(Long count) {
		this.count = count;
	}

	/**
	 * Gets the id.
	 *
	 * @return the id
	 */
	public int getId() {
		return this.id;
	}

	/**
	 * Sets the id.
	 *
	 * @param id
	 *            the new id
	 */
	public void setId(int id) {
		this.id = id;
	}

	/**
	 * Gets the description.
	 *
	 * @return the description
	 */
	public String getDescription() {
		return this.description;
	}

	/**
	 * Sets the description.
	 *
	 * @param description
	 *            the new description
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * Gets the comment histories.
	 *
	 * @return the comment histories
	 */
	public Set<CommentHistory> getCommentHistories() {
		return this.commentHistories;
	}

	/**
	 * Sets the comment histories.
	 *
	 * @param commentHistories
	 *            the new comment histories
	 */
	public void setCommentHistories(Set<CommentHistory> commentHistories) {
		this.commentHistories = commentHistories;
	}
}
